/*:saidoup.js
//=============================================================================

//=============================================================================

/*:
 * @plugindesc Apply saturation and brightness filters to all pictures.
 * @author [Your Name]
 *
 * @help This plugin allows you to adjust the saturation and brightness of
 * all pictures on the screen.
 *
 * @param Saturation
 * @desc Saturation value (-100 to 100).
 * @default 100
 *
 * @param Brightness
 * @desc Brightness value (-255 to 255).
 * @default 100
 *
 * @command adjustPictureFilters
 * @text Adjust Picture Filters
 * @desc Adjusts saturation and brightness of all pictures.
 *
 * @arg saturation
 * @text Saturation
 * @desc Saturation value (-100 to 100).
 * @default 100
 *
 * @arg brightness
 * @text Brightness
 * @desc Brightness value (-255 to 255).
 * @default 100
 */

(function() {
    var parameters = PluginManager.parameters('PictureFilter');
    var saturation = parseInt(parameters['Saturation']);
    var brightness = parseInt(parameters['Brightness']);

    // Register plugin command
    PluginManager.registerCommand('PictureFilter', 'adjustPictureFilters', function(args) {
        saturation = parseInt(args.saturation);
        brightness = parseInt(args.brightness);
        applyPictureFilters();
    });

    function applyPictureFilters() {
        var pictures = SceneManager._scene._spriteset._pictureContainer.children;
        pictures.forEach(function(picture) {
            if (picture.bitmap) {
                var context = picture.bitmap.context;
                context.filter = 'saturate(' + saturation + '%) brightness(' + brightness + '%)';
                picture.bitmap._setDirty();
            }
        });
    }
})();
